/* - MCVelocityChangeListener -
 * Display the velocity data after a Velocity change
 *
 * Copyright 2011 Phidgets Inc.
 * This work is licensed under the Creative Commons Attribution 2.5 Canada License. 
 * To view a copy of this license, visit http://creativecommons.org/licenses/by/2.5/ca/
 */
package listeners;

import com.phidgets.MotorControlPhidget;
import com.phidgets.PhidgetException;
import com.phidgets.event.MotorVelocityChangeListener;
import com.phidgets.event.MotorVelocityChangeEvent;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JComboBox;

public class MCVelocityChangeListener implements MotorVelocityChangeListener {

    private MotorControlPhidget mc;
    private JFrame appFrame;
    private JTextField currVelTxt;
    private JComboBox motorCmb;

    public MCVelocityChangeListener(MotorControlPhidget mc, JFrame appFrame, JTextField currVelTxt, JComboBox motorCmb) {
        this.mc = mc;
        this.appFrame = appFrame;
        this.currVelTxt = currVelTxt;
        this.motorCmb = motorCmb;
    }

    public void motorVelocityChanged(MotorVelocityChangeEvent motorVelocityChangeEvent) {
        if (motorVelocityChangeEvent.getIndex() == ((Integer) motorCmb.getSelectedItem()).intValue()) {
            try { 
                currVelTxt.setText(Double.toString(mc.getVelocity(((Integer) motorCmb.getSelectedItem()).intValue())));
            } catch (PhidgetException ex) {
                JOptionPane.showMessageDialog(appFrame, ex.getDescription(), "Phidget error " + ex.getErrorNumber(), JOptionPane.ERROR_MESSAGE);
            }
        }
    }
}
